package ru.yandex.direct.core.entity.banner.type.moderation;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.Nonnull;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyName;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;

import static ru.yandex.direct.common.db.PpcPropertyNames.CONTENT_PROMOTION_AUTO_MODERATION;
import static ru.yandex.direct.common.db.PpcPropertyNames.CONTENT_PROMOTION_COLLECTION_AUTO_MODERATION;

public class ContentPromotionBannersAutoModerationPropsHolder {
    private static final Set<AdGroupType> CONTENT_PROMOTION_ADGROUP_TYPES = ImmutableSet.of(
            AdGroupType.CONTENT_PROMOTION, AdGroupType.CONTENT_PROMOTION_VIDEO
    );
    public static final Set<ContentPromotionAdgroupType> AUTO_MODERATED_API_ONLY_CONTENT_PROMOTION_TYPES =
            Set.of(ContentPromotionAdgroupType.EDA, ContentPromotionAdgroupType.SERVICE);
    private final Map<ContentPromotionAdgroupType, Supplier<Boolean>> autoModerationProperties;

    public ContentPromotionBannersAutoModerationPropsHolder(@Nonnull PpcPropertiesSupport ppcPropertiesSupport) {
        autoModerationProperties = ImmutableMap.<ContentPromotionAdgroupType, Supplier<Boolean>>builder()
                .put(ContentPromotionAdgroupType.VIDEO,
                        new PpcPropertySupplier(ppcPropertiesSupport, CONTENT_PROMOTION_AUTO_MODERATION))
                .put(ContentPromotionAdgroupType.COLLECTION,
                        new PpcPropertySupplier(ppcPropertiesSupport, CONTENT_PROMOTION_COLLECTION_AUTO_MODERATION))
                .put(ContentPromotionAdgroupType.SERVICE, () -> true)
                .put(ContentPromotionAdgroupType.EDA, () -> true)
                .build();
    }

    public ContentPromotionBannersAutoModerationPropsHolder(@Nonnull PpcPropertiesSupport ppcPropertiesSupport,
                                                            Duration requiredDuration) {
        autoModerationProperties = ImmutableMap.<ContentPromotionAdgroupType, Supplier<Boolean>>builder()
                .put(ContentPromotionAdgroupType.VIDEO,
                        new PpcPropertySupplier(ppcPropertiesSupport, requiredDuration,
                                CONTENT_PROMOTION_AUTO_MODERATION))
                .put(ContentPromotionAdgroupType.COLLECTION,
                        new PpcPropertySupplier(ppcPropertiesSupport, requiredDuration,
                                CONTENT_PROMOTION_COLLECTION_AUTO_MODERATION))
                .put(ContentPromotionAdgroupType.SERVICE, () -> true)
                .put(ContentPromotionAdgroupType.EDA, () -> true)
                .build();
    }

    public boolean isBannerContentPromotionAndAutoModerated(AdGroupType adGroupType,
                                                            ContentPromotionAdgroupType
                                                                    contentPromotionAdGroupTypeForBanner) {
        if (!CONTENT_PROMOTION_ADGROUP_TYPES.contains(adGroupType)) {
            return false;
        }
        Supplier<Boolean> supplierForBanner = autoModerationProperties.get(
                adGroupType == AdGroupType.CONTENT_PROMOTION_VIDEO ?
                        ContentPromotionAdgroupType.VIDEO : contentPromotionAdGroupTypeForBanner);

        if (supplierForBanner == null) {
            return false;
        }
        return supplierForBanner.get();
    }

    private static class PpcPropertySupplier implements Supplier<Boolean> {
        PpcProperty<Boolean> ppcProperty;

        PpcPropertySupplier(PpcPropertiesSupport ppcPropertiesSupport, Duration duration,
                PpcPropertyName<Boolean> ppcPropertyName) {
            this.ppcProperty = ppcPropertiesSupport.get(ppcPropertyName, duration);
        }

        PpcPropertySupplier(PpcPropertiesSupport ppcPropertiesSupport, PpcPropertyName<Boolean> ppcPropertyName) {
            this.ppcProperty = ppcPropertiesSupport.get(ppcPropertyName);
        }

        @Override
        public Boolean get() {
            return ppcProperty.getOrDefault(false);
        }
    }
}
