package ru.yandex.direct.core.entity.banner.type.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;

import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.isOverlayBanner;

@Component
public class CpmBannerAddOperationModerationProcessor implements AddOperationModerationProcessor<CpmBanner> {
    private final DefaultAddOperationModerationProcessor defaultAddOperationModerationProcessor;

    public CpmBannerAddOperationModerationProcessor(DefaultAddOperationModerationProcessor defaultProcessor) {
        this.defaultAddOperationModerationProcessor = defaultProcessor;
    }

    @Override
    public Class<CpmBanner> getProcessedClass() {
        return CpmBanner.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersAddOperationContainer container, BannerWithModerationStatuses banner) {
        // Сначала вызываем дефолтную логику для статусов модерации и переотправки групп и кампаний
        defaultAddOperationModerationProcessor.process(additionalActionsContainer, container, banner);

        var adGroup = container.getAdGroup(banner);
        if (adGroup.getType() == AdGroupType.CPM_GEOPRODUCT && container.isCpmGeoProductAutoModeration()) {
            banner.withStatusModerate(BannerStatusModerate.YES)
                    .withStatusPostModerate(BannerStatusPostModerate.YES);
        }

        // Оверлейные баннеры не отправляем на модерацию
        if (isOverlayBanner(banner, container.getBannerToCreativeMap())) {
            banner.withStatusModerate(BannerStatusModerate.YES)
                    .withStatusPostModerate(BannerStatusPostModerate.YES);
        }
    }
}
