package ru.yandex.direct.core.entity.banner.type.moderation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;

@Component
public class CpmGeoPinBannerAddOperationModerationProcessor implements AddOperationModerationProcessor<CpmGeoPinBanner> {
    private final DefaultAddOperationModerationProcessor defaultAddOperationModerationProcessor;

    @Autowired
    public CpmGeoPinBannerAddOperationModerationProcessor(DefaultAddOperationModerationProcessor defaultProcessor) {
        this.defaultAddOperationModerationProcessor = defaultProcessor;
    }

    @Override
    public Class<CpmGeoPinBanner> getProcessedClass() {
        return CpmGeoPinBanner.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersAddOperationContainer container, BannerWithModerationStatuses banner) {

        // Сначала вызываем дефолтную логику для статусов модерации и переотправки групп и кампаний
        defaultAddOperationModerationProcessor.process(additionalActionsContainer, container, banner);

        var adGroup = container.getAdGroup(banner);
        if (adGroup.getType() == AdGroupType.CPM_GEO_PIN && container.isCpmGeoPinAutoModeration()) {
            banner.withStatusModerate(BannerStatusModerate.YES)
                    .withStatusPostModerate(BannerStatusPostModerate.YES);
        }

    }
}
