package ru.yandex.direct.core.entity.banner.type.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.service.BannerModerationUtils;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;

@Component
public class DefaultAddOperationModerationProcessor
        implements AddOperationModerationProcessor<BannerWithModerationStatuses> {

    @Override
    public Class<BannerWithModerationStatuses> getProcessedClass() {
        return BannerWithModerationStatuses.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersAddOperationContainer container,
                        BannerWithModerationStatuses banner) {
        boolean effectiveSaveDraft = BannerModerationUtils.isEffectiveSaveDraft(container, banner);

        banner
                .withStatusModerate(effectiveSaveDraft ?
                        BannerStatusModerate.NEW :
                        BannerStatusModerate.READY)
                .withStatusPostModerate(banner.getStatusPostModerate() == BannerStatusPostModerate.REJECTED
                        ? BannerStatusPostModerate.REJECTED
                        : BannerStatusPostModerate.NO);

        if (!effectiveSaveDraft) {
            CommonCampaign campaign = container.getCampaign(banner);
            additionalActionsContainer.addAdGroupIdForRemoderation(banner.getAdGroupId());
            additionalActionsContainer.addCampaignIdForRemoderation(campaign.getId());
        }
    }
}
