package ru.yandex.direct.core.entity.banner.type.moderation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;

import static ru.yandex.direct.core.entity.internalads.Constants.isModeratedTemplate;

@Component
public class InternalBannerAddOperationModerationProcessor implements AddOperationModerationProcessor<InternalBanner> {

    private final DefaultAddOperationModerationProcessor defaultAddOperationModerationProcessor;

    @Autowired
    public InternalBannerAddOperationModerationProcessor(DefaultAddOperationModerationProcessor defaultProcessor) {
        this.defaultAddOperationModerationProcessor = defaultProcessor;
    }

    @Override
    public Class<InternalBanner> getProcessedClass() {
        return InternalBanner.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersAddOperationContainer container,
                        BannerWithModerationStatuses banner) {
        // Сначала вызываем дефолтную логику для статусов модерации и переотправки групп и кампаний
        defaultAddOperationModerationProcessor.process(additionalActionsContainer, container, banner);

        // группы внутренней рекламы не модерируются, создаем всегда с statusModerate=Yes
        additionalActionsContainer.removeAdGroupIdFromRemoderation(banner.getAdGroupId());

        var internalBanner = (InternalBanner) banner;

        // Модерация только для определенных шаблонов
        if (!isModeratedTemplate(internalBanner.getTemplateId())) {
            internalBanner.withStatusModerate(BannerStatusModerate.YES)
                    .withStatusPostModerate(BannerStatusPostModerate.YES);
            additionalActionsContainer.addAdGroupIdForBSResync(banner.getAdGroupId());
        } else {
            boolean sendToModeration = internalBanner.getModerationInfo().getSendToModeration();

            // позволяем при создании выбирать сохранить в черновик или отправить на модерацию, вне зависимости от того,
            // что кампания в черновике или нет
            banner.setStatusModerate(sendToModeration ? BannerStatusModerate.READY : BannerStatusModerate.NEW);
        }
    }

}
