package ru.yandex.direct.core.entity.banner.type.moderation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.service.BannerModerationUtils;

@ParametersAreNonnullByDefault
@Component
public class PerformanceBannerAddOperationModerationProcessor implements
        AddOperationModerationProcessor<PerformanceBanner> {

    @Override
    public Class<PerformanceBanner> getProcessedClass() {
        return PerformanceBanner.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersAddOperationContainer container,
                        BannerWithModerationStatuses banner) {
        // в случае смарт-баннеров модерируются не они, а соответствующие креативы
        if (BannerModerationUtils.isEffectiveSaveDraft(container, banner)) {
            banner.withStatusModerate(BannerStatusModerate.NEW)
                    .withStatusPostModerate(BannerStatusPostModerate.NO);
        } else {
            banner.withStatusModerate(BannerStatusModerate.YES)
                    .withStatusPostModerate(BannerStatusPostModerate.YES);

            additionalActionsContainer.addAdGroupIdForSettingBlProcessing(banner.getAdGroupId());
        }
    }

}
