package ru.yandex.direct.core.entity.banner.type.moderation

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain

@Component
class PerformanceMainBannerAddOperationModerationProcessor(
    private val defaultAddOperationModerationProcessor: DefaultAddOperationModerationProcessor
) : AddOperationModerationProcessor<PerformanceBannerMain> {
    override fun getProcessedClass() = PerformanceBannerMain::class.java

    override fun process(additionalActionsContainer: BannerAdditionalActionsContainer,
                         container: BannersAddOperationContainer,
                         banner: BannerWithModerationStatuses) {
        defaultAddOperationModerationProcessor.process(additionalActionsContainer, container, banner)
        if (banner.statusModerate != BannerStatusModerate.NEW) {
            additionalActionsContainer.addAdGroupIdForSettingBlProcessing(banner.adGroupId)
        }
    }
}
