package ru.yandex.direct.core.entity.banner.type.moderation.model;

import java.util.Set;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerDisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerVcardStatusModerate;
import ru.yandex.direct.core.entity.banner.model.NewStatusImageModerate;
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.currency.Currencies;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;

public class BannerStatusInfo {
    private static final Set<BannerStatusModerate> BANNER_ON_MODERATE_STATUSES = ImmutableSet.of(
            BannerStatusModerate.SENDING,
            BannerStatusModerate.READY,
            BannerStatusModerate.SENT);
    private static final Set<BannerVcardStatusModerate> PHONE_FLAG_ON_MODERATE_STATUSES =
            ImmutableSet.of(BannerVcardStatusModerate.SENDING,
                    BannerVcardStatusModerate.READY,
                    BannerVcardStatusModerate.SENT);
    private static final Set<BannerStatusSitelinksModerate> SITELINKS_ON_MODERATE_STATUSES =
            ImmutableSet.of(BannerStatusSitelinksModerate.SENDING,
                    BannerStatusSitelinksModerate.READY,
                    BannerStatusSitelinksModerate.SENT);
    private static final Set<StatusBannerImageModerate> IMAGE_ON_MODERATE_STATUSES =
            ImmutableSet.of(StatusBannerImageModerate.SENDING,
                    StatusBannerImageModerate.READY,
                    StatusBannerImageModerate.SENT);
    private static final Set<ru.yandex.direct.core.entity.adgroup.model.StatusModerate> ADGROUP_ON_MODERATE_STATUSES =
            ImmutableSet.of(ru.yandex.direct.core.entity.adgroup.model.StatusModerate.SENDING,
                    ru.yandex.direct.core.entity.adgroup.model.StatusModerate.READY,
                    ru.yandex.direct.core.entity.adgroup.model.StatusModerate.SENT);
    private static final Set<BannerCreativeStatusModerate> BANNER_CREATIVE_ON_MODERATE_STATUSES =
            ImmutableSet.of(BannerCreativeStatusModerate.SENDING,
                    BannerCreativeStatusModerate.READY,
                    BannerCreativeStatusModerate.SENT);
    private static final Set<NewStatusImageModerate> BANNER_IMAGE_AD_ON_MODERATE_STATUSES =
            ImmutableSet.of(NewStatusImageModerate.SENDING, NewStatusImageModerate.READY, NewStatusImageModerate.SENT);
    private static final Set<BannerDisplayHrefStatusModerate> DISPLAY_HREF_ON_MODERATE_STATUSES =
            ImmutableSet.of(BannerDisplayHrefStatusModerate.SENDING,
                    BannerDisplayHrefStatusModerate.READY,
                    BannerDisplayHrefStatusModerate.SENT);
    private static final Set<BannerTurboLandingStatusModerate> BANNER_TURBO_LANDING_ON_MODERATE_STATUSES =
            ImmutableSet.of(BannerTurboLandingStatusModerate.SENDING,
                    BannerTurboLandingStatusModerate.READY,
                    BannerTurboLandingStatusModerate.SENT);
    private static final Set<BannersBannerType> BANNER_TYPES_FOR_ACTIVATION =
            ImmutableSet.of(BannersBannerType.dynamic, BannersBannerType.mobile_content, BannersBannerType.performance,
                    BannersBannerType.image_ad, BannersBannerType.cpm_banner);
    private static final Set<BannerStatusPostModerate> BANNER_STATUS_POST_MODERATE_YES_REJECTED =
            ImmutableSet.of(BannerStatusPostModerate.YES, BannerStatusPostModerate.REJECTED);
    private static final Set<ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate>
            ADGROUP_STATUS_POST_MODERATE_YES_REJECTED =
            ImmutableSet.of(
                    ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate.YES,
                    ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate.REJECTED);

    private Long bannerId;
    private Long adgroupId;
    private StatusModerate adGroupStatusModerate;
    private StatusPostModerate adGroupStatusPostModerate;
    private boolean archived = false;
    private boolean showActive = false;
    private boolean showAccepted = false;
    private boolean campHasMoney = false;
    private boolean moderateBannerAccepted = false;
    private boolean moderateDeclined = false;
    private boolean moderateWait = false;
    private boolean moderateContactDeclined = false;
    private boolean moderateContactWait = false;
    private boolean moderateSitelinksDeclined = false;
    private boolean moderateSitelinksWait = false;
    private boolean moderateVideoAdditionDeclined = false;
    private boolean moderateVideoAdditionWait = false;
    private boolean moderatePhrasesDeclined = false;
    private boolean moderateImageDeclined = false;
    private boolean moderateImageWait = false;
    private boolean moderateDisplayHrefDeclined = false;
    private boolean moderateDisplayHrefWait = false;
    private boolean moderateCalloutDeclined = false;
    private boolean moderateTurbolandingDeclined = false;
    private boolean moderateTurbolandingWait = false;
    private boolean draft = false;
    private boolean activation = false;
    private boolean stopped = false;
    private boolean blNothingGenerated = false;
    private boolean blProcessing = false;
    private boolean keywordsDeclined = false;
    private boolean statusActive = false;
    private boolean statusShow = false;
    private BannerStatusModerate statusModerate;
    private BannerStatusPostModerate statusPostModerate;
    private Long bsBannerId;
    private String textStatus = null;

    public BannerStatusInfo(Long bannerId) {
        this.bannerId = bannerId;
    }

    public boolean hasTrueStatuses() {
        return isArchived()
                || isShowActive()
                || isShowAccepted()
                || isModerateBannerAccepted()
                || isModerateDeclined()
                || isModerateWait()
                || isModerateContactDeclined()
                || isModerateContactWait()
                || isModerateSitelinksDeclined()
                || isModerateSitelinksWait()
                || isModerateVideoAdditionDeclined()
                || isModerateVideoAdditionWait()
                || isModeratePhrasesDeclined()
                || isModerateImageDeclined()
                || isModerateImageWait()
                || isModerateDisplayHrefDeclined()
                || isModerateDisplayHrefWait()
                || isModerateCalloutDeclined()
                || isModerateTurbolandingDeclined()
                || isModerateTurbolandingWait()
                || isDraft()
                || isActivation()
                || isStopped()
                || isBlNothingGenerated()
                || isBlProcessing();
    }

    public Long getBannerId() {
        return bannerId;
    }

    public Long getAdgroupId() {
        return adgroupId;
    }

    public void setAdgroupId(Long adgroupId) {
        this.adgroupId = adgroupId;
    }

    public boolean isArchived() {
        return archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isShowActive() {
        return showActive;
    }

    public void setShowActive(boolean showActive) {
        this.showActive = showActive;
    }

    public StatusModerate getAdGroupStatusModerate() {
        return adGroupStatusModerate;
    }

    public void setAdGroupStatusModerate(StatusModerate adGroupStatusModerate) {
        this.adGroupStatusModerate = adGroupStatusModerate;
    }

    public StatusPostModerate getAdGroupStatusPostModerate() {
        return adGroupStatusPostModerate;
    }

    public void setAdGroupStatusPostModerate(StatusPostModerate adGroupStatusPostModerate) {
        this.adGroupStatusPostModerate = adGroupStatusPostModerate;
    }

    public boolean isShowAccepted() {
        return showAccepted;
    }

    public void setShowAccepted(boolean showAccepted) {
        this.showAccepted = showAccepted;
    }

    public boolean isModerateBannerAccepted() {
        return moderateBannerAccepted;
    }

    public void setModerateBannerAccepted(boolean moderateBannerAccepted) {
        this.moderateBannerAccepted = moderateBannerAccepted;
    }

    public boolean isModerateDeclined() {
        return moderateDeclined;
    }

    public void setModerateDeclined(boolean moderateDeclined) {
        this.moderateDeclined = moderateDeclined;
    }

    public boolean isModerateWait() {
        return moderateWait;
    }

    public void setModerateWait(boolean moderateWait) {
        this.moderateWait = moderateWait;
    }

    public boolean isModerateContactDeclined() {
        return moderateContactDeclined;
    }

    public void setModerateContactDeclined(boolean moderateContactDeclined) {
        this.moderateContactDeclined = moderateContactDeclined;
    }

    public boolean isModerateContactWait() {
        return moderateContactWait;
    }

    public void setModerateContactWait(boolean moderateContactWait) {
        this.moderateContactWait = moderateContactWait;
    }

    public boolean isModerateSitelinksDeclined() {
        return moderateSitelinksDeclined;
    }

    public void setModerateSitelinksDeclined(boolean moderateSitelinksDeclined) {
        this.moderateSitelinksDeclined = moderateSitelinksDeclined;
    }

    public boolean isModerateSitelinksWait() {
        return moderateSitelinksWait;
    }

    public void setModerateSitelinksWait(boolean moderateSitelinksWait) {
        this.moderateSitelinksWait = moderateSitelinksWait;
    }

    public boolean isModerateVideoAdditionDeclined() {
        return moderateVideoAdditionDeclined;
    }

    public void setModerateVideoAdditionDeclined(boolean moderateVideoAdditionDeclined) {
        this.moderateVideoAdditionDeclined = moderateVideoAdditionDeclined;
    }

    public boolean isModerateVideoAdditionWait() {
        return moderateVideoAdditionWait;
    }

    public void setModerateVideoAdditionWait(boolean moderateVideoAdditionWait) {
        this.moderateVideoAdditionWait = moderateVideoAdditionWait;
    }

    public boolean isModeratePhrasesDeclined() {
        return moderatePhrasesDeclined;
    }

    public void setModeratePhrasesDeclined(boolean moderatePhrasesDeclined) {
        this.moderatePhrasesDeclined = moderatePhrasesDeclined;
    }

    public boolean isModerateImageDeclined() {
        return moderateImageDeclined;
    }

    public void setModerateImageDeclined(boolean moderateImageDeclined) {
        this.moderateImageDeclined = moderateImageDeclined;
    }

    public boolean isModerateImageWait() {
        return moderateImageWait;
    }

    public void setModerateImageWait(boolean moderateImageWait) {
        this.moderateImageWait = moderateImageWait;
    }

    public boolean isModerateDisplayHrefDeclined() {
        return moderateDisplayHrefDeclined;
    }

    public void setModerateDisplayHrefDeclined(boolean moderateDisplayHrefDeclined) {
        this.moderateDisplayHrefDeclined = moderateDisplayHrefDeclined;
    }

    public boolean isModerateDisplayHrefWait() {
        return moderateDisplayHrefWait;
    }

    public void setModerateDisplayHrefWait(boolean moderateDisplayHrefWait) {
        this.moderateDisplayHrefWait = moderateDisplayHrefWait;
    }

    public boolean isModerateCalloutDeclined() {
        return moderateCalloutDeclined;
    }

    public void setModerateCalloutDeclined(boolean moderateCalloutDeclined) {
        this.moderateCalloutDeclined = moderateCalloutDeclined;
    }

    public boolean isModerateTurbolandingDeclined() {
        return moderateTurbolandingDeclined;
    }

    public void setModerateTurbolandingDeclined(boolean moderateTurbolandingDeclined) {
        this.moderateTurbolandingDeclined = moderateTurbolandingDeclined;
    }

    public boolean isModerateTurbolandingWait() {
        return moderateTurbolandingWait;
    }

    public void setModerateTurbolandingWait(boolean moderateTurbolandingWait) {
        this.moderateTurbolandingWait = moderateTurbolandingWait;
    }

    public boolean isDraft() {
        return draft;
    }

    public void calculateDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isActivation() {
        return activation;
    }

    public void setActivation(boolean activation) {
        this.activation = activation;
    }

    public boolean isStopped() {
        return stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isBlNothingGenerated() {
        return blNothingGenerated;
    }

    public void setBlNothingGenerated(boolean blNothingGenerated) {
        this.blNothingGenerated = blNothingGenerated;
    }

    public boolean isBlProcessing() {
        return blProcessing;
    }

    public void setBlProcessing(boolean blProcessing) {
        this.blProcessing = blProcessing;
    }

    public boolean isKeywordsDeclined() {
        return keywordsDeclined;
    }

    public void setKeywordsDeclined(boolean keywordsDeclined) {
        this.keywordsDeclined = keywordsDeclined;
    }

    public boolean isStatusActive() {
        return statusActive;
    }

    public void setStatusActive(boolean statusActive) {
        this.statusActive = statusActive;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public boolean isStatusShow() {
        return statusShow;
    }

    public void setStatusShow(boolean statusShow) {
        this.statusShow = statusShow;
    }

    public BannerStatusModerate getStatusModerate() {
        return statusModerate;
    }

    public void setStatusModerate(BannerStatusModerate statusModerate) {
        this.statusModerate = statusModerate;
    }

    public BannerStatusPostModerate getStatusPostModerate() {
        return statusPostModerate;
    }

    public void setStatusPostModerate(BannerStatusPostModerate statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
    }

    public Long getBsBannerId() {
        return bsBannerId;
    }

    public void setBsBannerId(Long bsBannerId) {
        this.bsBannerId = bsBannerId;
    }

    public String getTextStatus() {
        return textStatus;
    }

    public void setTextStatus(String textStatus) {
        this.textStatus = textStatus;
    }

    public boolean isCampHasMoney() {
        return campHasMoney;
    }

    public void setCampHasMoney(boolean campHasMoney) {
        this.campHasMoney = campHasMoney;
    }

    public static BannerStatusInfo getBannerStatusInfo(BannerStatuses bannerWithStatuses) {


        BannerStatusInfo statusInfo = new BannerStatusInfo(bannerWithStatuses.getId());
        statusInfo.setStatusActive(bannerWithStatuses.getBannerStatusActive());
        statusInfo.setStatusShow(bannerWithStatuses.getBannerStatusShow());
        statusInfo.setStatusModerate(bannerWithStatuses.getBannerStatusModerate());
        statusInfo.setStatusPostModerate(bannerWithStatuses.getBannerStatusPostModerate());
        statusInfo.setBsBannerId(bannerWithStatuses.getBsBannerId());
        statusInfo.setAdgroupId(bannerWithStatuses.getAdgroupId());
        statusInfo.setAdGroupStatusPostModerate(bannerWithStatuses.getAdgroupStatusPostModerate());
        statusInfo.setAdGroupStatusModerate(bannerWithStatuses.getAdgroupStatusModerate());


        if (bannerWithStatuses.getBannerStatusArch()) {
            statusInfo.setArchived(true);
            return statusInfo;
        }

        // NB: по состоянию на 2018.09.27 признак вычисляется неправильно для кампаний под неотключаемым общим счетом
        // на котором закончились все деньги, смотри DIRECT-85857
        statusInfo.setCampHasMoney(bannerWithStatuses.getCampaignBalance().compareTo(Currencies.EPSILON) > 0
                && bannerWithStatuses.getCampaignSumToPay().compareTo(Currencies.EPSILON) < 0);

        statusInfo = calculateStatusModerate(bannerWithStatuses, statusInfo);

        statusInfo = calculateDraft(bannerWithStatuses, statusInfo);

        statusInfo = calculateStop(bannerWithStatuses, statusInfo);

        statusInfo = calculateActivating(bannerWithStatuses, statusInfo);

        statusInfo = calculateDynamicAndPreformanceBanners(bannerWithStatuses, statusInfo);

        statusInfo = calculateShowActive(bannerWithStatuses, statusInfo);

        return statusInfo;
    }

    /*
        Определяем флаги модерации: ожидает какой-то элемент объявления модерации или вовсе отклонен.
     */
    private static BannerStatusInfo calculateStatusModerate(BannerStatuses bannerWithStatuses,
                                                            BannerStatusInfo statusInfo) {
        boolean bannerOnModerate = BANNER_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getBannerStatusModerate());
        boolean adGroupOnModerate =
                ADGROUP_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getAdgroupStatusModerate());
        boolean phoneOnModerate = PHONE_FLAG_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getBannerPhoneFlag());
        boolean sitelinksOnModerate =
                SITELINKS_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getBannerStatusSitelinksModerate());
        boolean textBannerImageOnModerate =
                IMAGE_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getBannerStatusImageModerate());
        boolean bannerBasedOnCreativeOnModerate =
                BANNER_CREATIVE_ON_MODERATE_STATUSES
                        .contains(bannerWithStatuses.getBannerBasedOnCreativeStatusModerate());
        boolean hrefDisplayOnModerate =
                DISPLAY_HREF_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getBannerDisplayHrefStatusModerate());
        boolean bannerTurbolandingOnModerate =
                BANNER_TURBO_LANDING_ON_MODERATE_STATUSES
                        .contains(bannerWithStatuses.getBannerTurbolandingStatusModerate());
        boolean bannerVideoOnModerate =
                BANNER_CREATIVE_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getVideoAdditionsStatusModerate());
        boolean imageAdOnModerate =
                BANNER_IMAGE_AD_ON_MODERATE_STATUSES.contains(bannerWithStatuses.getBannerImageAdStatusModerate());

        boolean campCanShow = bannerWithStatuses.getCampaignStatusShow() && statusInfo.isCampHasMoney();

        boolean bannerStatusSentYes = bannerWithStatuses.getBannerStatusModerate().equals(BannerStatusModerate.SENT)
                && bannerWithStatuses.getBannerStatusPostModerate().equals(BannerStatusPostModerate.YES);

        bannerOnModerate = bannerOnModerate
                || bannerWithStatuses.getBannerStatusModerate() != BannerStatusModerate.NEW && imageAdOnModerate
                || bannerWithStatuses.getBannerStatusModerate() != BannerStatusModerate.NEW
                && bannerBasedOnCreativeOnModerate
                || bannerWithStatuses.getBannerType() == BannersBannerType.dynamic && adGroupOnModerate;

        boolean bannerPostAccepted = bannerWithStatuses.getBannerStatusPostModerate() == BannerStatusPostModerate.YES
                && bannerWithStatuses.getAdgroupStatusPostModerate()
                == ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate.YES
                && (bannerWithStatuses.getBannerHasHref()
                || bannerWithStatuses.getBannerPhoneFlag() == BannerVcardStatusModerate.YES);

        boolean bannerAccepted = bannerWithStatuses.getBannerStatusModerate() == BannerStatusModerate.YES
                && bannerWithStatuses.getAdgroupStatusModerate()
                == ru.yandex.direct.core.entity.adgroup.model.StatusModerate.YES
                || bannerWithStatuses.getBannerBasedOnCreativeStatusModerate() == BannerCreativeStatusModerate.YES;

        boolean bannerDeclined = bannerWithStatuses.getBannerStatusModerate() == BannerStatusModerate.NO
                || bannerWithStatuses.getAdgroupStatusModerate()
                == ru.yandex.direct.core.entity.adgroup.model.StatusModerate.NO
                || bannerWithStatuses.getBannerBasedOnCreativeStatusModerate() == BannerCreativeStatusModerate.NO;

        if (bannerOnModerate) {
            boolean showActive = bannerPostAccepted
                    && bannerWithStatuses.getBannerStatusShow()
                    && campCanShow
                    && !imageAdOnModerate
                    && !bannerBasedOnCreativeOnModerate;

            statusInfo.setShowActive(showActive && bannerStatusSentYes);

            statusInfo.setModerateWait(!showActive);
        }

        statusInfo.setShowAccepted(
                //баннер пост промодерирован
                bannerPostAccepted
                        // И показывается сейчас в БК
                        && bannerWithStatuses.getBannerStatusShow()
                        // И ( баннер на модерации, но не показывается
                        //     ИЛИ кампания промодерирована, но без денег)
                        && (bannerOnModerate && !campCanShow
                        || bannerWithStatuses.getCampaignStatusModerate().equals(CampaignStatusModerate.YES)
                        && !statusInfo.isCampHasMoney()));

        statusInfo.setModerateBannerAccepted(bannerAccepted && (phoneOnModerate || sitelinksOnModerate));

        statusInfo.setModerateContactWait(phoneOnModerate && !bannerOnModerate && !bannerDeclined);

        statusInfo.setModerateSitelinksWait(sitelinksOnModerate && !bannerOnModerate && !bannerDeclined);

        statusInfo.setModerateImageWait(textBannerImageOnModerate && !bannerOnModerate && !bannerDeclined);

        statusInfo.setModerateDisplayHrefWait(hrefDisplayOnModerate && !bannerOnModerate && !bannerDeclined);

        statusInfo.setModerateVideoAdditionWait(bannerVideoOnModerate && !bannerOnModerate && !bannerDeclined);

        statusInfo
                .setModerateTurbolandingWait(bannerTurbolandingOnModerate && !bannerOnModerate && !bannerDeclined);

        statusInfo.setModerateDeclined(bannerDeclined && !bannerOnModerate);

        statusInfo.setModerateContactDeclined(
                bannerAccepted && bannerWithStatuses.getBannerPhoneFlag().equals(BannerVcardStatusModerate.NO));

        statusInfo.setModeratePhrasesDeclined(bannerAccepted && bannerWithStatuses.getKeywordsDeclined());

        statusInfo.setModerateSitelinksDeclined(bannerAccepted
                && bannerWithStatuses.getBannerStatusSitelinksModerate() != null
                && bannerWithStatuses.getBannerStatusSitelinksModerate().equals(BannerStatusSitelinksModerate.NO));

        statusInfo.setModerateImageDeclined(bannerAccepted
                && bannerWithStatuses.getBannerStatusImageModerate() != null
                && bannerWithStatuses.getBannerStatusImageModerate().equals(StatusBannerImageModerate.NO));

        statusInfo.setModerateDisplayHrefDeclined(bannerAccepted
                && bannerWithStatuses.getBannerDisplayHrefStatusModerate() != null
                && bannerWithStatuses.getBannerDisplayHrefStatusModerate()
                .equals(BannerDisplayHrefStatusModerate.NO));

        statusInfo.setModerateVideoAdditionDeclined(bannerAccepted
                && bannerWithStatuses.getVideoAdditionsStatusModerate() != null
                && bannerWithStatuses.getVideoAdditionsStatusModerate().equals(BannerCreativeStatusModerate.NO));

        statusInfo.setModerateTurbolandingDeclined(bannerAccepted
                && bannerWithStatuses.getBannerTurbolandingStatusModerate() != null
                && bannerWithStatuses.getBannerTurbolandingStatusModerate()
                .equals(BannerTurboLandingStatusModerate.NO));

        statusInfo.setModerateCalloutDeclined(bannerWithStatuses.getAdditionsCalloutsDeclined() != null
                && bannerWithStatuses.getAdditionsCalloutsDeclined());

        statusInfo.setKeywordsDeclined(bannerWithStatuses.getKeywordsDeclined());

        return statusInfo;
    }

    /*
        Определяем черновик баннер или нет.
     */
    private static BannerStatusInfo calculateDraft(BannerStatuses bannerWithStatuses,
                                                   BannerStatusInfo bannerStatusInfo) {
        boolean isDraft =
                //  Если баннер только был создан, ни разу не отправлялся на модерацию
                bannerWithStatuses.getBannerStatusModerate().equals(BannerStatusModerate.NEW)
                        // ИЛИ группа ни разу не отправлялась на модерацию
                        || bannerWithStatuses.getAdgroupStatusModerate()
                        .equals(ru.yandex.direct.core.entity.adgroup.model.StatusModerate.NEW)
                        // ИЛИ кампания ни разу не отправлялась на модерацию
                        || bannerWithStatuses.getCampaignStatusModerate()
                        .equals(ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate.NEW)
                        // или есть дополнения картинкой и она тоже еще ни разу не отправлялась на модерацию
                        || bannerWithStatuses.getBannerBasedOnCreativeStatusModerate()
                        == BannerCreativeStatusModerate.NEW;

        bannerStatusInfo.calculateDraft(isDraft);
        return bannerStatusInfo;
    }

    /*
        Определяем флаг отправляется ли на активацию объявление или нет.
    */
    private static BannerStatusInfo calculateStop(BannerStatuses bannerWithStatuses, BannerStatusInfo statusInfo) {
        statusInfo.setStopped(!bannerWithStatuses.getBannerStatusShow()
                && !statusInfo.isDraft()
                && !statusInfo.isModerateDeclined()
                && !statusInfo.isModeratePhrasesDeclined()
                && !statusInfo.isModerateWait());

        return statusInfo;
    }

    /*
        Определяем флаг отправляется ли на активацию объявление или нет.
     */
    private static BannerStatusInfo calculateActivating(BannerStatuses bannerWithStatuses,
                                                        BannerStatusInfo statusInfo) {
        //баннер хотябы раз был в БК, но не показывается в текущий момент
        // ИЛИ
        // статус пост модерации баннера Yes или Rejected
        //     И статус пост модерации группы Yes или Rejected
        //     И баннер успешно отмодерирован или тип баннера не с картинкой
        boolean isPostModerated = bannerWithStatuses.getBsBannerId() > 0 && !bannerWithStatuses.getBannerStatusShow()
                || BANNER_STATUS_POST_MODERATE_YES_REJECTED.contains(bannerWithStatuses.getBannerStatusPostModerate())
                && ADGROUP_STATUS_POST_MODERATE_YES_REJECTED.contains(bannerWithStatuses.getAdgroupStatusPostModerate())
                && (!ImmutableSet.of(BannersBannerType.image_ad, BannersBannerType.cpm_banner)
                .contains(bannerWithStatuses.getBannerType())
                || bannerWithStatuses.getBannerStatusModerate().equals(BannerStatusModerate.YES));

        boolean isActivating =
                // баннер не новый и уже на модерации был
                !bannerWithStatuses.getBannerStatusModerate().equals(BannerStatusModerate.NEW)
                        // у компании есть деньги, открутки могут быть только на проплаченной кампании
                        && statusInfo.isCampHasMoney()
                        // баннер изменился и не успел отправиться в БК, то есть в БК еще предыдущая версия крутится
                        // или не был баннер там никогда
                        // ИЛИ группа не успела отправиться в БК, при этом баннер показывается
                        && (!bannerWithStatuses.getBannerStatusBsSynced().equals(StatusBsSynced.YES)
                        || (!bannerWithStatuses.getAdgroupStatusBsSynced().equals(StatusBsSynced.YES)
                        && bannerWithStatuses.getBannerStatusShow()))
                        // кампания показывается
                        && bannerWithStatuses.getCampaignStatusShow()
                        // баннер хотябы раз был в БК или показывается в текуций момент
                        && (bannerWithStatuses.getBsBannerId() > 0 || bannerWithStatuses.getBannerStatusShow())
                        // у баннера есть ссылка или промодерированная визитка или типа это динамический баннер,
                        // смарт-баннер, мобильный или с картинкой
                        && (bannerWithStatuses.getBannerHasHref()
                        || bannerWithStatuses.getBannerPhoneFlag().equals(BannerVcardStatusModerate.YES)
                        || BANNER_TYPES_FOR_ACTIVATION.contains(bannerWithStatuses.getBannerType()))
                        // Нет сайтлинков на модерации
                        && !SITELINKS_ON_MODERATE_STATUSES
                        .contains(bannerWithStatuses.getBannerStatusSitelinksModerate())
                        && isPostModerated;

        statusInfo.setActivation(isActivating);

        return statusInfo;
    }

    /*
        Определяем флаги специфичные для динамических и смарт-объявлений.
     */
    private static BannerStatusInfo calculateDynamicAndPreformanceBanners(BannerStatuses bannerWithStatuses,
                                                                          BannerStatusInfo statusInfo) {
        if ((bannerWithStatuses.getBannerType().equals(BannersBannerType.dynamic)
                || bannerWithStatuses.getBannerType().equals(BannersBannerType.performance))
                && bannerWithStatuses.getBsBannerId() > 0
                && bannerWithStatuses.getBannerStatusShow()
                && !statusInfo.hasTrueStatuses()
                && bannerWithStatuses.getAdgroupPerformanceStatusBLGenerated() != null
                && !bannerWithStatuses.getAdgroupPerformanceStatusBLGenerated().equals(StatusBLGenerated.YES)) {

            statusInfo.setBlNothingGenerated(
                    bannerWithStatuses.getAdgroupPerformanceStatusBLGenerated().equals(StatusBLGenerated.NO));
            statusInfo.setBlProcessing(
                    bannerWithStatuses.getAdgroupPerformanceStatusBLGenerated().equals(StatusBLGenerated.PROCESSING));
        }
        return statusInfo;
    }

    /*
        Определяем флаг активное ли объявление, или нет.
     */
    private static BannerStatusInfo calculateShowActive(BannerStatuses bannerWithStatuses,
                                                        BannerStatusInfo statusInfo) {
        if (bannerWithStatuses.getCampaignStatusShow()
                && statusInfo.isCampHasMoney()
                && !statusInfo.hasTrueStatuses()) {
            statusInfo.setShowActive(bannerWithStatuses.getBannerStatusModerate().equals(BannerStatusModerate.SENT)
                    && bannerWithStatuses.getBannerStatusPostModerate().equals(BannerStatusPostModerate.YES));
        }
        return statusInfo;
    }

}
