package ru.yandex.direct.core.entity.banner.type.moderation.update;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.AppliedChanges;

public abstract class AbstractUpdateOperationModerationProcessor<T extends BannerWithModerationStatuses, C>
        implements UpdateOperationModerationProcessor<T> {
    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersUpdateOperationContainer container,
                        List<AppliedChanges<BannerWithSystemFields>> bannerChanges,
                        Set<Long> bannerIdsToModerate) {
        bannerChanges.forEach(bannerChange -> {
            var moderationContainer = prepareContainer(bannerChanges);
            var banner = bannerChange.getModel();
            var needModeration = bannerIdsToModerate.contains(banner.getId());
            process(additionalActionsContainer, container, moderationContainer, bannerChange, needModeration);
        });
    }

    protected abstract void process(BannerAdditionalActionsContainer additionalActionsContainer,
                                    BannersUpdateOperationContainer container,
                                    C moderationContainer,
                                    AppliedChanges<BannerWithSystemFields> bannerChanges,
                                    boolean needModeration);

    protected abstract C prepareContainer(List<AppliedChanges<BannerWithSystemFields>> bannerChanges);
}
