package ru.yandex.direct.core.entity.banner.type.moderation.update;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.type.moderation.ContentPromotionBannersAutoModerationPropsHolder;
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.DefaultModerationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.moderation.ContentPromotionBannersAutoModerationPropsHolder.AUTO_MODERATED_API_ONLY_CONTENT_PROMOTION_TYPES;

@Component
public class ContentPromotionUpdateOperationModerationProcessor
        extends AbstractDefaultUpdateOperationModerationProcessor<ContentPromotionBanner> {

    private final ContentPromotionBannersAutoModerationPropsHolder autoModerationPropsHolder;
    private final DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor;

    @Autowired
    public ContentPromotionUpdateOperationModerationProcessor(
            PpcPropertiesSupport ppcPropertiesSupport,
            DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor) {
        this.autoModerationPropsHolder = new ContentPromotionBannersAutoModerationPropsHolder(ppcPropertiesSupport);
        this.defaultUpdateOperationModerationProcessor = defaultUpdateOperationModerationProcessor;
    }

    @Override
    public Class<ContentPromotionBanner> getProcessedClass() {
        return ContentPromotionBanner.class;
    }

    @Override
    protected void process(BannerAdditionalActionsContainer additionalActionsContainer,
                           BannersUpdateOperationContainer container,
                           DefaultModerationContainer moderationContainer,
                           AppliedChanges<BannerWithSystemFields> bannerChanges,
                           boolean needModeration) {
        defaultUpdateOperationModerationProcessor.process(additionalActionsContainer,
                container, moderationContainer, bannerChanges, needModeration);
        var banner = bannerChanges.getModel();

        ContentPromotionAdgroupType contentPromotionAdgroupType = container.getContentPromotionAdGroupType(banner);
        boolean isContentPromotionModerated = autoModerationPropsHolder
                .isBannerContentPromotionAndAutoModerated(AdGroupType.CONTENT_PROMOTION, contentPromotionAdgroupType);

        if (isContentPromotionModerated) {
            bannerChanges.modify(ContentPromotionBanner.STATUS_MODERATE, BannerStatusModerate.YES);
            bannerChanges.modify(ContentPromotionBanner.STATUS_POST_MODERATE, BannerStatusPostModerate.YES);

            // для баннеров продвижения Услуг и продвижения Еды отправляем группу и кампанию из черновиков на модерацию
            if (!AUTO_MODERATED_API_ONLY_CONTENT_PROMOTION_TYPES.contains(contentPromotionAdgroupType)) {
                additionalActionsContainer.removeAdGroupIdFromRemoderation(banner.getAdGroupId());
            } else {
                // если у кампании был statusModerate=NEW, то группа не попала в список, поэтому добавляем отдельно
                additionalActionsContainer.addAdGroupIdForRemoderation(banner.getAdGroupId());
                additionalActionsContainer.addCampaignIdForRemoderationForContentPromotion(banner.getCampaignId());
            }
            additionalActionsContainer.removeCampaignIdFromRemoderation(banner.getCampaignId());

            additionalActionsContainer.removeBannerToClearModerationFlags(banner);
        }
    }
}
