package ru.yandex.direct.core.entity.banner.type.moderation.update;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.CpmBannerModerationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.isOverlayBanner;
import static ru.yandex.direct.core.entity.banner.type.moderation.update.UpdateOperationModerationHelper.autoModerateBanner;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class CpmBannerUpdateOperationModerationProcessor
        extends AbstractUpdateOperationModerationProcessor<CpmBanner, CpmBannerModerationContainer> {

    private final DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor;

    @Autowired
    public CpmBannerUpdateOperationModerationProcessor(
            DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor) {
        this.defaultUpdateOperationModerationProcessor = defaultUpdateOperationModerationProcessor;
    }

    @Override
    public Class<CpmBanner> getProcessedClass() {
        return CpmBanner.class;
    }

    @Override
    public CpmBannerModerationContainer prepareContainer(List<AppliedChanges<BannerWithSystemFields>> bannerChanges) {
        return new CpmBannerModerationContainer();
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersUpdateOperationContainer container,
                        List<AppliedChanges<BannerWithSystemFields>> bannerChanges,
                        Set<Long> bannerIdsToModerate) {
        List<AppliedChanges<BannerWithSystemFields>> changes = mapList(bannerChanges,
                c -> c.castModelUp(BannerWithSystemFields.class));
        defaultUpdateOperationModerationProcessor.process(additionalActionsContainer,
                container, changes, bannerIdsToModerate);

        super.process(additionalActionsContainer, container, bannerChanges, bannerIdsToModerate);
    }

    @Override
    protected void process(BannerAdditionalActionsContainer additionalActionsContainer,
                           BannersUpdateOperationContainer container,
                           CpmBannerModerationContainer moderationContainer,
                           AppliedChanges<BannerWithSystemFields> bannerChanges,
                           boolean needModeration) {
        var banner = bannerChanges.getModel();
        var adGroup = container.getAdGroup(banner);

        if (adGroup.getType() == AdGroupType.CPM_GEOPRODUCT && container.isCpmGeoProductAutoModeration()) {
            autoModerateBanner(
                    additionalActionsContainer,
                    bannerChanges.castModelUp(BannerWithSystemFields.class),
                    banner.getCampaignId());
        }

        if (isOverlayBanner(bannerChanges.getModel(), container.getBannerToCreativeMap())) {
            autoModerateBanner(
                    additionalActionsContainer,
                    bannerChanges.castModelUp(BannerWithSystemFields.class),
                    banner.getCampaignId());
        }
    }
}
