package ru.yandex.direct.core.entity.banner.type.moderation.update;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.DefaultModerationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.moderation.update.UpdateOperationModerationHelper.autoModerateBanner;

@Component
public class CpmGeoPinUpdateOperationModerationProcessor
        extends AbstractDefaultUpdateOperationModerationProcessor<CpmGeoPinBanner> {

    private final DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor;

    @Autowired
    public CpmGeoPinUpdateOperationModerationProcessor(
            DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor) {
        this.defaultUpdateOperationModerationProcessor = defaultUpdateOperationModerationProcessor;
    }

    @Override
    public Class<CpmGeoPinBanner> getProcessedClass() {
        return CpmGeoPinBanner.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersUpdateOperationContainer container,
                        List<AppliedChanges<BannerWithSystemFields>> bannerChanges,
                        Set<Long> bannerIdsToModerate) {
        defaultUpdateOperationModerationProcessor.process(additionalActionsContainer,
                container, bannerChanges, bannerIdsToModerate);
        super.process(additionalActionsContainer, container, bannerChanges, bannerIdsToModerate);
    }

    @Override
    protected void process(
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer container,
            DefaultModerationContainer moderationContainer,
            AppliedChanges<BannerWithSystemFields> bannerChanges,
            boolean needModeration) {
        var banner = bannerChanges.getModel();

        if (container.isCpmGeoPinAutoModeration()) {
            autoModerateBanner(
                    additionalActionsContainer,
                    bannerChanges,
                    banner.getCampaignId());
        }
    }
}
