package ru.yandex.direct.core.entity.banner.type.moderation.update;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.DefaultModerationContainer;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerIsOnModeration;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerWasDraft;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.campaignIsDraft;

@Component
public class DefaultUpdateOperationModerationProcessor
        extends AbstractDefaultUpdateOperationModerationProcessor<BannerWithModerationStatuses> {

    @Override
    public Class<BannerWithModerationStatuses> getProcessedClass() {
        return BannerWithModerationStatuses.class;
    }

    @Override
    protected void process(BannerAdditionalActionsContainer additionalActionsContainer,
                           BannersUpdateOperationContainer container,
                           DefaultModerationContainer moderationContainer,
                           AppliedChanges<BannerWithSystemFields> bannerChanges,
                           boolean needModeration) {
        ModerationMode moderationMode = container.getModerationMode();
        if (!bannerChanges.hasActuallyChangedProps() && moderationMode.isDefault()) {
            return;
        }
        BannerWithSystemFields banner = bannerChanges.getModel();
        CommonCampaign campaign = container.getCampaign(banner);

        boolean bannerWasDraft = bannerWasDraft(bannerChanges);
        boolean moderationAllowed = !campaignIsDraft(campaign);
        boolean moderateUnconditionally = moderationAllowed && bannerWasDraft && moderationMode.isForceModerate();
        boolean moderateIfChanged = moderationAllowed && !bannerWasDraft &&
                (moderationMode.isDefault() || moderationMode.isForceModerate());
        boolean forceSaveDraft = container.getModerationMode().isForceSaveDraft();

        if (bannerWasDraft) {
            bannerChanges.modify(BannerWithModerationStatuses.STATUS_POST_MODERATE, BannerStatusPostModerate.NO);
        }

        if (forceSaveDraft) {
            bannerChanges.modify(BannerWithModerationStatuses.STATUS_MODERATE, BannerStatusModerate.NEW);
            bannerChanges.modify(BannerWithModerationStatuses.STATUS_POST_MODERATE, BannerStatusPostModerate.NO);

        } else if (moderateUnconditionally) {
            sendToModerationBannerWithAdGroupAndCampaign(additionalActionsContainer, bannerChanges, campaign.getId());
        } else if (moderateIfChanged) {
            if (needModeration && !bannerIsOnModeration(banner)) {
                sendToModerationBannerWithAdGroupAndCampaign(additionalActionsContainer, bannerChanges,
                        campaign.getId());
            }
        }
    }

    private void sendToModerationBannerWithAdGroupAndCampaign(
            BannerAdditionalActionsContainer additionalActionsContainer,
            AppliedChanges<BannerWithSystemFields> bannerChanges,
            Long campaignId) {
        var banner = bannerChanges.getModel();

        // Отправляем на модерацию
        bannerChanges.modify(BannerWithModerationStatuses.STATUS_MODERATE, BannerStatusModerate.READY);
        if (banner.getStatusPostModerate() != BannerStatusPostModerate.REJECTED) {
            bannerChanges.modify(BannerWithModerationStatuses.STATUS_POST_MODERATE,
                    BannerStatusPostModerate.NO);
        }

        // проверка статусов групп и кампаний происходит в репозиториях
        additionalActionsContainer.addAdGroupIdForRemoderation(banner.getAdGroupId());
        additionalActionsContainer.addCampaignIdForRemoderation(campaignId);
        additionalActionsContainer.addBannerToClearModerationFlags(banner);
    }
}
