package ru.yandex.direct.core.entity.banner.type.moderation.update

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields
import ru.yandex.direct.core.entity.banner.model.DynamicBanner
import ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.moderateUnconditionally
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.DefaultModerationContainer
import ru.yandex.direct.model.AppliedChanges

@Component
class DynamicBannerUpdateOperationModerationProcessor(
    private val defaultUpdateOperationModerationProcessor: DefaultUpdateOperationModerationProcessor
) : AbstractDefaultUpdateOperationModerationProcessor<DynamicBanner>() {
    override fun getProcessedClass() = DynamicBanner::class.java

    override fun process(additionalActionsContainer: BannerAdditionalActionsContainer,
                         container: BannersUpdateOperationContainer,
                         moderationContainer: DefaultModerationContainer,
                         bannerChanges: AppliedChanges<BannerWithSystemFields>,
                         needModeration: Boolean) {
        defaultUpdateOperationModerationProcessor.process(additionalActionsContainer, container, moderationContainer,
            bannerChanges, needModeration)
        if (moderateUnconditionally(bannerChanges)) {
            additionalActionsContainer.addAdGroupIdForSettingBlProcessing(bannerChanges.model.adGroupId)
        }
    }
}
