package ru.yandex.direct.core.entity.banner.type.moderation.update;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.DefaultModerationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class InternalBannerUpdateOperationModerationProcessor
        extends AbstractDefaultUpdateOperationModerationProcessor<InternalBanner> {

    private final DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor;

    @Autowired
    public InternalBannerUpdateOperationModerationProcessor(
            DefaultUpdateOperationModerationProcessor defaultUpdateOperationModerationProcessor) {
        this.defaultUpdateOperationModerationProcessor = defaultUpdateOperationModerationProcessor;
    }

    @Override
    public Class<InternalBanner> getProcessedClass() {
        return InternalBanner.class;
    }

    @Override
    protected void process(BannerAdditionalActionsContainer additionalActionsContainer,
                           BannersUpdateOperationContainer container,
                           DefaultModerationContainer moderationContainer,
                           AppliedChanges<BannerWithSystemFields> bannerChanges,
                           boolean needModeration) {
        // Сначала вызываем дефолтную логику для статусов модерации и переотправки групп и кампаний
        defaultUpdateOperationModerationProcessor.process(additionalActionsContainer,
                container, moderationContainer, bannerChanges, needModeration);

        // группы внутренней рекламы не модерируются, создаем всегда с statusModerate=Yes
        additionalActionsContainer.removeAdGroupIdFromRemoderation(bannerChanges.getModel().getAdGroupId());

        if (needModeration) {
            InternalBanner banner = bannerChanges.castModelUp(InternalBanner.class).getModel();
            boolean sendToModeration = banner.getModerationInfo().getSendToModeration();

            // позволяем при апдейте выбирать сохранить в черновик или отправить на модерацию, вне зависимости от того,
            // что кампания в черновике или нет
            if (sendToModeration) {
                bannerChanges.modify(BannerWithSystemFields.STATUS_MODERATE, BannerStatusModerate.READY);
            } else {
                bannerChanges.modify(BannerWithSystemFields.STATUS_MODERATE, BannerStatusModerate.NEW);
                bannerChanges.modify(BannerWithSystemFields.STATUS_POST_MODERATE, BannerStatusPostModerate.NO);
            }
        }
    }

}
