package ru.yandex.direct.core.entity.banner.type.moderation.update;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.service.BannerModerationUtils;
import ru.yandex.direct.core.entity.banner.service.BannerUtils;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.banner.type.moderation.update.container.DefaultModerationContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerWasDraft;

@ParametersAreNonnullByDefault
@Component
public class PerformanceBannerUpdateOperationModerationProcessor extends
        AbstractDefaultUpdateOperationModerationProcessor<PerformanceBanner> {

    @Autowired
    public PerformanceBannerUpdateOperationModerationProcessor() {
    }

    @Override
    protected void process(BannerAdditionalActionsContainer additionalActionsContainer,
                           BannersUpdateOperationContainer container,
                           DefaultModerationContainer moderationContainer,
                           AppliedChanges<BannerWithSystemFields> bannerChanges,
                           boolean needModeration) {
        sendPerformanceBannersToModeration(bannerChanges, additionalActionsContainer, container);
    }

    private void sendPerformanceBannersToModeration(
            AppliedChanges<BannerWithSystemFields> bannerChanges,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer container) {
        boolean needMarkDraftPerformanceAdGroupAsModerated = false;

        ModerationMode moderationMode = container.getModerationMode();
        if (!bannerChanges.hasActuallyChangedProps() && moderationMode.isDefault()) {
            return;
        }

        BannerWithSystemFields model = bannerChanges.getModel();
        CommonCampaign campaign = container.getCampaign(model);

        boolean bannerWasDraft = bannerWasDraft(bannerChanges);
        boolean campaignIsDraft = campaign.getStatusModerate() == CampaignStatusModerate.NEW;
        boolean saveDraft = moderationMode.isForceSaveDraft() || campaignIsDraft;
        boolean moderateUnconditionally = !campaignIsDraft && bannerWasDraft && moderationMode.isForceModerate();

        // Статус модерации на баннере должен быть `New` или `Yes`
        if (saveDraft) {
            bannerChanges.modify(PerformanceBanner.STATUS_MODERATE, BannerStatusModerate.NEW);
            bannerChanges.modify(PerformanceBanner.STATUS_POST_MODERATE, BannerStatusPostModerate.NO);
        } else if (moderateUnconditionally) {

            bannerChanges.modify(PerformanceBanner.STATUS_MODERATE, BannerStatusModerate.YES);
            bannerChanges.modify(PerformanceBanner.STATUS_POST_MODERATE, BannerStatusPostModerate.YES);
            needMarkDraftPerformanceAdGroupAsModerated = true;

        }

        if (needMarkDraftPerformanceAdGroupAsModerated) {
            additionalActionsContainer.addDraftPerformanceAdGroupAsModerated(model.getAdGroupId());
        }

        boolean needBSResyncAdGroup = needPerformanceAdgroupsToResendBsOnUpdate(bannerChanges);
        if (needBSResyncAdGroup) {
            additionalActionsContainer.addAdGroupIdForBSResync(model.getAdGroupId());
        }

        if (BannerModerationUtils.moderateUnconditionally(bannerChanges)) {
            additionalActionsContainer.addAdGroupIdForSettingBlProcessing(model.getAdGroupId());
        }
    }

    private static boolean needPerformanceAdgroupsToResendBsOnUpdate(AppliedChanges<BannerWithSystemFields> changes) {
        return Optional.of(changes)
                .filter(AppliedChanges::hasActuallyChangedProps)
                .map(AppliedChanges::getModel)
                .filter(BannerUtils::bannerNeverSentToBs)
                .isPresent();
    }

    @Override
    public Class<PerformanceBanner> getProcessedClass() {
        return PerformanceBanner.class;
    }

}
