package ru.yandex.direct.core.entity.banner.type.moderation.update;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.AppliedChanges;

public class UpdateOperationModerationHelper {

    private UpdateOperationModerationHelper() {
    }

    static void autoModerateBanner(
            BannerAdditionalActionsContainer additionalActionsContainer,
            AppliedChanges<BannerWithSystemFields> bannerChanges,
            Long campaignId) {
        var banner = bannerChanges.getModel();
        bannerChanges.modify(BannerWithModerationStatuses.STATUS_MODERATE, BannerStatusModerate.YES);
        bannerChanges.modify(BannerWithModerationStatuses.STATUS_POST_MODERATE, BannerStatusPostModerate.YES);

        additionalActionsContainer.removeAdGroupIdFromRemoderation(banner.getAdGroupId());
        additionalActionsContainer.removeCampaignIdFromRemoderation(campaignId);

        additionalActionsContainer.removeBannerToClearModerationFlags(banner);
    }

}
