package ru.yandex.direct.core.entity.banner.type.moderation.update;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.AppliedChanges;

public interface UpdateOperationModerationProcessor<T extends BannerWithModerationStatuses> {

    Class<T> getProcessedClass();

    /**
     * В bannerChanges должен быть ограничивающий интерфейс, а не конечный тип, чтобы нельзя было поменять в баннере
     * все что угодно.
     */
    void process(BannerAdditionalActionsContainer additionalActionsContainer,
                 BannersUpdateOperationContainer container,
                 List<AppliedChanges<BannerWithSystemFields>> bannerChanges,
                 Set<Long> bannerIdsToModerate);
}
