package ru.yandex.direct.core.entity.banner.type.moderationstatuses;

import java.util.List;
import java.util.function.Predicate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerStatusModerate.READY;
import static ru.yandex.direct.core.entity.banner.model.BannerStatusModerate.SENDING;
import static ru.yandex.direct.core.entity.banner.model.BannerStatusModerate.SENT;
import static ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses.STATUS_MODERATE;
import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;

@Component
public class BannerWithModerationStatusesProcessor {

    private static final List<BannerStatusModerate> REMODERATE_STATUSES = List.of(READY, SENT, SENDING);
    private final BannerModerationRepository bannerModerationRepository;

    @Autowired
    public BannerWithModerationStatusesProcessor(BannerModerationRepository bannerModerationRepository) {
        this.bannerModerationRepository = bannerModerationRepository;
    }

    /**
     * Удалить записи о минус-гео для баннеров отправленных на перемодерацию (Ready|Sending|Sent)
     * В AppliedChanges при отправке на модерацию мы проставляем обычно статус Ready
     * Но на всякий случай добавлены проверки на все статусы
     */
    public void deleteMinusGeo(int shard, List<AppliedChanges<BannerWithModerationStatuses>> appliedChanges) {
        Predicate<AppliedChanges<BannerWithModerationStatuses>> sentToModerate =
                ac -> ac.changed(STATUS_MODERATE) && REMODERATE_STATUSES.contains(ac.getNewValue(STATUS_MODERATE));

        List<Long> bannerIds = filterAndMapList(appliedChanges, sentToModerate, x -> x.getModel().getId());
        bannerModerationRepository.deleteMinusGeo(shard, bannerIds);
    }
}
