package ru.yandex.direct.core.entity.banner.type.moderationstatuses;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
@ParametersAreNonnullByDefault
public class BannerWithModerationStatusesRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithModerationStatuses> {

    private static final String ERROR_MESSAGE_TEMPLATE = "banner fields equal to null: %s";

    @Autowired
    public BannerWithModerationStatusesRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,

                BannerWithModerationStatuses.STATUS_MODERATE,
                BANNERS.STATUS_MODERATE,
                BannerStatusModerate::fromSource,
                BannerStatusModerate::toSource,

                BannerWithModerationStatuses.STATUS_POST_MODERATE,
                BANNERS.STATUS_POST_MODERATE,
                BannerStatusPostModerate::fromSource,
                BannerStatusPostModerate::toSource
        );
    }

    @Override
    public Class<BannerWithModerationStatuses> getTypeClass() {
        return BannerWithModerationStatuses.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithModerationStatuses model) {
        checkFieldsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithModerationStatuses>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldsNotNull(x.getModel()));
    }

    private void checkFieldsNotNull(BannerWithModerationStatuses model) {
        String nullFields = StreamEx.of(BannerWithModerationStatuses.allModelProperties())
                .filter(modelProperty -> modelProperty.getRaw(model) == null)
                .map(ModelProperty::name)
                .joining(", ");
        if (!StringUtils.isEmpty(nullFields)) {
            throw new NullPointerException(String.format(ERROR_MESSAGE_TEMPLATE, nullFields));
        }
    }
}
