package ru.yandex.direct.core.entity.banner.type.moderationstatuses;


import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithModerationStatusesUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithModerationStatuses> {

    private final BannerWithModerationStatusesProcessor bannerWithModerationStatusesProcessor;

    @Autowired
    public BannerWithModerationStatusesUpdateOperationTypeSupport(
            BannerWithModerationStatusesProcessor bannerWithModerationStatusesProcessor) {
        this.bannerWithModerationStatusesProcessor = bannerWithModerationStatusesProcessor;
    }

    @Override
    public Class<BannerWithModerationStatuses> getTypeClass() {
        return BannerWithModerationStatuses.class;
    }

    @Override
    public void afterExecution(BannersUpdateOperationContainer updateContainer,
                               List<AppliedChanges<BannerWithModerationStatuses>> appliedChanges) {
        bannerWithModerationStatusesProcessor.deleteMinusGeo(updateContainer.getShard(), appliedChanges);
    }


}
