package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_MULTICARDS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Component
class BannerMulticardSetsRepository(
    private val dslContextProvider: DslContextProvider,
) {
    fun getBannerIdsByMulticardIds(shard: Int, multicardIds: Collection<Long>): Set<Long> {
        if (multicardIds.isEmpty()) {
            return setOf()
        }

        return dslContextProvider.ppc(shard)
            .select(BANNER_MULTICARDS.BID)
            .from(BANNER_MULTICARDS)
            .where(BANNER_MULTICARDS.MULTICARD_ID.`in`(multicardIds))
            .fetchSet(BANNER_MULTICARDS.BID)
    }
}
