package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerMulticardSetStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSet
import ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport

@Component
class BannerWithMulticardSetAddOperationTypeSupport : AbstractBannerAddOperationTypeSupport<BannerWithMulticardSet>() {
    override fun getTypeClass() = BannerWithMulticardSet::class.java

    override fun beforeExecution(addContainer: BannersAddOperationContainer, models: List<BannerWithMulticardSet>) {
        models.forEach { banner ->
            if (banner.multicards != null) {
                val effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner)
                banner.multicardSetStatusModerate = if (effectiveSaveDraft) {
                    BannerMulticardSetStatusModerate.NEW
                } else {
                    BannerMulticardSetStatusModerate.READY
                }
            }
        }
    }
}
