package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerMulticard
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSet
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.item
import ru.yandex.direct.validation.util.validateList
import ru.yandex.direct.validation.util.validateModel

@Component
class BannerWithMulticardSetAddValidationTypeSupport(
    private val bannerWithMulticardSetValidatorProvider: BannerWithMulticardSetValidatorProvider,
) : AbstractBannerAddValidationTypeSupport<BannerWithMulticardSet>() {
    override fun getTypeClass() = BannerWithMulticardSet::class.java

    override fun validate(
        container: BannersAddOperationContainer,
        vr: ValidationResult<List<BannerWithMulticardSet>, Defect<*>>,
    ): ValidationResult<List<BannerWithMulticardSet>, Defect<*>> {
        return validateList(vr) {
            checkEachBy(bannerWithMulticardSetAddValidator())

            checkEachBy(bannerWithMulticardSetValidatorProvider.bannerWithMulticardValidator(container, vr.value))
        }
    }

    private fun bannerWithMulticardSetAddValidator(): Validator<BannerWithMulticardSet, Defect<*>> {
        return Validator { banner ->
            validateModel(banner) {
                item(BannerWithMulticardSet.MULTICARDS) {
                    checkBy(bannerMulticardAddValidator(), When.notNull())
                }
            }
        }
    }

    private fun bannerMulticardAddValidator() =
        Validator { multicards: List<BannerMulticard> ->
            validateList(multicards) {
                checkEachBy { multicard ->
                    validateModel(multicard) {
                        item(BannerMulticard.MULTICARD_ID) {
                            check(CommonConstraints.isNull())
                        }
                    }
                }
            }
        }
}
