package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetAndBannerImage
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateList

@Component
class BannerWithMulticardSetAndBannerImageAddValidationTypeSupport(
    private val validatorProvider: BannerWithMulticardSetAndBannerImageValidatorProvider,
) : AbstractBannerAddValidationTypeSupport<BannerWithMulticardSetAndBannerImage>() {

    override fun getTypeClass() = BannerWithMulticardSetAndBannerImage::class.java

    override fun preValidate(
        container: BannersAddOperationContainer,
        vr: ValidationResult<List<BannerWithMulticardSetAndBannerImage>, Defect<*>>
    ): ValidationResult<List<BannerWithMulticardSetAndBannerImage>, Defect<*>> {
        return validateList(vr) {
            checkEachBy(validatorProvider.bannerWithMulticardSetAndBannerImageValidator())
        }
    }
}
