package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetAndBannerImage
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateList

@Component
class BannerWithMulticardSetAndBannerImageUpdateValidationTypeSupport(
    private val validatorProvider: BannerWithMulticardSetAndBannerImageValidatorProvider,
) : AbstractBannerUpdateValidationTypeSupport<BannerWithMulticardSetAndBannerImage>() {

    override fun getTypeClass() = BannerWithMulticardSetAndBannerImage::class.java

    override fun validate(
        container: BannersUpdateOperationContainer,
        vr: ValidationResult<List<BannerWithMulticardSetAndBannerImage>, Defect<*>>
    ): ValidationResult<List<BannerWithMulticardSetAndBannerImage>, Defect<*>> {
        return validateList(vr) {
            checkEachBy(validatorProvider.bannerWithMulticardSetAndBannerImageValidator())
        }
    }
}
