package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetAndBannerImage
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.util.item
import ru.yandex.direct.validation.util.validateModel

@Component
class BannerWithMulticardSetAndBannerImageValidatorProvider {
    fun bannerWithMulticardSetAndBannerImageValidator(): Validator<BannerWithMulticardSetAndBannerImage, Defect<*>> {
        return Validator { banner ->
            validateModel(banner) {
                val hasMulticardSet = banner.multicards != null
                item(BannerWithMulticardSetAndBannerImage.IMAGE_HASH) {
                    check(notNull(), When.isTrue(hasMulticardSet))
                }
            }
        }
    }
}
