package ru.yandex.direct.core.entity.banner.type.multicard

import org.jooq.DSLContext
import org.jooq.util.mysql.MySQLDSL
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.model.BannerMulticardSetStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetStatusModerate
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_MULTICARD_SETS
import ru.yandex.direct.dbschema.ppc.tables.records.BannerMulticardSetsRecord
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty
import ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty
import ru.yandex.direct.jooqmapperhelper.InsertHelper
import ru.yandex.direct.model.AppliedChanges

@Component
class BannerWithMulticardSetStatusModerateRepositoryTypeSupport(
    dslContextProvider: DslContextProvider,
) : AbstractFlatRelatedEntityUpsertRepositoryTypeSupport<BannerWithMulticardSetStatusModerate, BannerMulticardSetsRecord>(
    dslContextProvider,
    BANNER_MULTICARD_SETS.BID,
    createMapper()
) {
    companion object {
        private fun createMapper() = JooqMapperBuilder.builder<BannerWithMulticardSetStatusModerate>()
            .writeField(BANNER_MULTICARD_SETS.BID, fromProperty(BannerWithMulticardSetStatusModerate.ID))
            .map(
                convertibleProperty(
                    BannerWithMulticardSetStatusModerate.MULTICARD_SET_STATUS_MODERATE,
                    BANNER_MULTICARD_SETS.STATUS_MODERATE,
                    BannerMulticardSetStatusModerate::fromSource,
                    BannerMulticardSetStatusModerate::toSource,
                )
            )
            .build()
    }

    override fun getTypeClass() = BannerWithMulticardSetStatusModerate::class.java

    override fun upsertEntity(context: DSLContext, banners: Collection<BannerWithMulticardSetStatusModerate>) {
        val helper = InsertHelper(context, BANNER_MULTICARD_SETS)
        helper.addAll(jooqMapper, banners)
            .onDuplicateKeyUpdate()
            .set(BANNER_MULTICARD_SETS.STATUS_MODERATE, MySQLDSL.values(BANNER_MULTICARD_SETS.STATUS_MODERATE))
        helper.executeIfRecordsAdded()
    }

    override fun isAddEntity(model: BannerWithMulticardSetStatusModerate) =
        model.multicardSetStatusModerate != null

    override fun isUpsertEntity(appliedChange: AppliedChanges<BannerWithMulticardSetStatusModerate>) =
        appliedChange.changedAndNotDeleted(BannerWithMulticardSetStatusModerate.MULTICARD_SET_STATUS_MODERATE)

    override fun isDeleteEntity(appliedChange: AppliedChanges<BannerWithMulticardSetStatusModerate>) =
        appliedChange.deleted(BannerWithMulticardSetStatusModerate.MULTICARD_SET_STATUS_MODERATE)
}
