package ru.yandex.direct.core.entity.banner.type.multicard

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSet
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges

@Component
class BannerWithMulticardSetUpdateOperationTypeSupport : AbstractBannerUpdateOperationTypeSupport<BannerWithMulticardSet>() {
    override fun getTypeClass() = BannerWithMulticardSet::class.java

    override fun needBsResync(appliedChanges: AppliedChanges<BannerWithMulticardSet>) =
        appliedChanges.changed(BannerWithMulticardSet.MULTICARDS)

    override fun needLastChangeReset(appliedChanges: AppliedChanges<BannerWithMulticardSet>) =
        appliedChanges.changed(BannerWithMulticardSet.MULTICARDS)
}
