package ru.yandex.direct.core.entity.banner.type.multicard.moderation

import org.apache.commons.collections4.CollectionUtils
import org.apache.commons.collections4.Equator
import org.jooq.DSLContext
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerMulticard
import ru.yandex.direct.core.entity.banner.model.BannerMulticardSetStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetModeration
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetModeration.MULTICARDS
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetModeration.MULTICARD_SET_STATUS_MODERATE
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetModeration.STATUS_MODERATE
import ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProcessor
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.model.ModelProperty
import java.util.Objects

interface BannerWithMulticardSetModerationProcessor :
    BannerWithChildrenModerationProcessor<BannerWithMulticardSetModeration>

@Component
class DefaultBannerWithMulticardSetModerationProcessor : BannerWithMulticardSetModerationProcessor {
    override fun getProcessedClass() = BannerWithMulticardSetModeration::class.java

    override fun process(
        dsl: DSLContext,
        additionalActionsContainer: BannerAdditionalActionsContainer,
        container: BannersUpdateOperationContainer,
        appliedChanges: List<AppliedChanges<BannerWithMulticardSetModeration>>
    ) {
        for (ac in appliedChanges) {
            if (!ac.hasActuallyChangedProps() && container.moderationMode.isDefault) {
                continue
            }

            val newMulticards = ac.getNewValue(MULTICARDS)
            val oldMulticards = ac.getOldValue(MULTICARDS) ?: emptyList()

            if (newMulticards == null) {
                ac.modify(MULTICARD_SET_STATUS_MODERATE, null)
                continue
            }

            if (bannerBecameDraft(ac)) {
                ac.modify(MULTICARD_SET_STATUS_MODERATE, BannerMulticardSetStatusModerate.NEW)
                continue
            }

            if (ac.getNewValue(STATUS_MODERATE) == BannerStatusModerate.READY) {
                ac.modify(MULTICARD_SET_STATUS_MODERATE, BannerMulticardSetStatusModerate.READY)
                continue
            }

            if (hasChanges(newMulticards, oldMulticards)) {
                ac.modify(MULTICARD_SET_STATUS_MODERATE, BannerMulticardSetStatusModerate.READY)
            }
        }
    }

    /**
     * Переупорядочивание карточек не приводит к сбросу статуса модерации, любые другие изменения приводят:
     * - Добавление карточки (у таких карточек `multicardId == null`)
     * - Удаление карточки (карточки с этим `multicardId` отсутствуют в [newMulticards])
     * - Изменение полей (для карточек с равным `multicardId`)
     */
    private fun hasChanges(newMulticards: List<BannerMulticard>, oldMulticards: List<BannerMulticard>): Boolean {
        return !CollectionUtils.isEqualCollection(newMulticards, oldMulticards)
    }
}
