package ru.yandex.direct.core.entity.banner.type.multicard.moderation

import org.jooq.DSLContext
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSetModeration
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges

@Component
class BannerWithMulticardSetModerationUpdateOperationTypeSupport(
    processors: List<BannerWithMulticardSetModerationProcessor>,
) : AbstractBannerUpdateOperationTypeSupport<BannerWithMulticardSetModeration>() {

    private val provider =
        BannerWithChildrenModerationProvider(DefaultBannerWithMulticardSetModerationProcessor::class.java, processors)

    override fun getTypeClass() = BannerWithMulticardSetModeration::class.java

    override fun beforeExecutionInTransaction(
        dslContext: DSLContext,
        additionalActionsContainer: BannerAdditionalActionsContainer,
        updateContainer: BannersUpdateOperationContainer,
        appliedChanges: MutableList<AppliedChanges<BannerWithMulticardSetModeration>>,
    ) = provider.process(
        dslContext,
        additionalActionsContainer,
        updateContainer,
        appliedChanges
    )
}
