package ru.yandex.direct.core.entity.banner.type.name;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_NAMES;

@Repository
public class BannerNamesRepository {

    public void deleteNamesForBanners(DSLContext context, List<Long> bannerIds) {
        if (bannerIds.isEmpty()) {
            return;
        }
        context.delete(BANNER_NAMES)
                .where(BANNER_NAMES.BID.in(bannerIds))
                .execute();
    }

}
