package ru.yandex.direct.core.entity.banner.type.name;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerNameStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithName;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;

@Component
public class BannerWithNameAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithName> {

    @Override
    public Class<BannerWithName> getTypeClass() {
        return BannerWithName.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithName> models) {
        models.forEach(banner -> fillSystemFields(addContainer, banner));
    }

    private void fillSystemFields(BannersAddOperationContainer addContainer, BannerWithName banner) {
        var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);

        if (banner.getName() != null) {
            banner.withNameStatusModerate(effectiveSaveDraft ?
                    BannerNameStatusModerate.NEW : BannerNameStatusModerate.READY);
        }
    }
}
