package ru.yandex.direct.core.entity.banner.type.name;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.model.BannerNameStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithName;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerNamesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_NAMES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithNameRepositoryTypeSupport
        extends AbstractFlatRelatedEntityRepositoryTypeSupport<BannerWithName, BannerNamesRecord> {

    @Autowired
    public BannerWithNameRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_NAMES.BID, createMapper());
    }

    @Override
    protected void addEntities(DSLContext context,
                               BannerRepositoryContainer updateParameters,
                               Collection<BannerWithName> entities) {
        InsertHelper<BannerNamesRecord> insertHelper = new InsertHelper<>(context, BANNER_NAMES)
                .addAll(getJooqMapper(), entities);
        insertHelper.executeIfRecordsAdded();
    }

    @Override
    protected boolean isAddEntity(BannerWithName model) {
        return model.getName() != null;
    }

    @Override
    protected boolean isAddEntity(AppliedChanges<BannerWithName> appliedChange) {
        return appliedChange.assigned(BannerWithName.NAME);
    }

    @Override
    protected boolean isUpdateEntity(AppliedChanges<BannerWithName> appliedChange) {
        return appliedChange.replaced(BannerWithName.NAME) ||
                appliedChange.replaced(BannerWithName.NAME_STATUS_MODERATE);
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithName> appliedChange) {
        return appliedChange.deleted(BannerWithName.NAME);
    }

    @Override
    public Class<BannerWithName> getTypeClass() {
        return BannerWithName.class;
    }

    private static JooqMapper<BannerWithName> createMapper() {
        return JooqMapperBuilder.<BannerWithName>builder()
                .map(property(BannerWithName.NAME, BANNER_NAMES.NAME))
                .map(convertibleProperty(BannerWithName.NAME_STATUS_MODERATE,
                        BANNER_NAMES.STATUS_MODERATE,
                        BannerNameStatusModerate::fromSource,
                        BannerNameStatusModerate::toSource))
                .writeField(BANNER_NAMES.BID, fromProperty(BannerWithName.ID))
                .build();
    }
}
