package ru.yandex.direct.core.entity.banner.type.name;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithName;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithNameUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithName> {

    @Override
    public Class<BannerWithName> getTypeClass() {
        return BannerWithName.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithName> appliedChanges) {
        return appliedChanges.changed(BannerWithName.NAME);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithName> appliedChanges) {
        return appliedChanges.changed(BannerWithName.NAME);
    }
}

