package ru.yandex.direct.core.entity.banner.type.name;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithName;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithNameUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithName> {
    private final BannerWithNameValidatorProvider validatorProvider;

    @Autowired
    public BannerWithNameUpdateValidationTypeSupport(BannerWithNameValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithName> getTypeClass() {
        return BannerWithName.class;
    }

    @Override
    public ValidationResult<List<BannerWithName>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithName>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithNameValidator(container, vr.getValue()))
                .getResult();
    }
}
