package ru.yandex.direct.core.entity.banner.type.name;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithName;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Component
public class BannerWithNameValidatorProvider {

    private static final int MAX_NAME_LENGTH = 50;

    public ListItemValidator<BannerWithName, Defect> bannerWithNameValidator(BannersOperationContainer container,
                                                                             List<BannerWithName> banners) {
        return (index, banner) -> {
            ModelItemValidationBuilder<BannerWithName> vb = ModelItemValidationBuilder.of(banner);

            vb.item(BannerWithName.NAME)
                    .check(notBlank())
                    .check(maxStringLength(MAX_NAME_LENGTH));

            return vb.getResult();
        };
    }
}
