package ru.yandex.direct.core.entity.banner.type.name.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithNameModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithNameModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithNameModeration> {

    private final BannerWithChildrenModerationProvider<BannerWithNameModeration> provider;

    @Autowired
    public BannerWithNameModerationUpdateOperationTypeSupport(
            List<BannerWithNameModerationProcessor> processors) {

        this.provider = new BannerWithChildrenModerationProvider<>(
                DefaultBannerWithNameModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithNameModeration> getTypeClass() {
        return BannerWithNameModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithNameModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
