package ru.yandex.direct.core.entity.banner.type.name.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerNameStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerWithName;
import ru.yandex.direct.core.entity.banner.model.BannerWithNameModeration;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft;

@Component
public class DefaultBannerWithNameModerationProcessor implements BannerWithNameModerationProcessor {

    @Override
    public Class<? extends BannerWithNameModeration> getProcessedClass() {
        return BannerWithNameModeration.class;
    }

    @Override
    public void process(DSLContext dsl,
                        BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersUpdateOperationContainer container,
                        List<AppliedChanges<BannerWithNameModeration>> appliedChanges) {
        for (AppliedChanges<BannerWithNameModeration> changes : appliedChanges) {
            if (!changes.hasActuallyChangedProps() && container.getModerationMode().isDefault()) {
                continue;
            }

            if (changes.getNewValue(BannerWithName.NAME) == null) {
                continue;
            }

            if (bannerBecameDraft(changes)) {
                changes.modify(BannerWithName.NAME_STATUS_MODERATE, BannerNameStatusModerate.NEW);
                continue;
            }

            if (changes.getNewValue(BannerWithModerationStatuses.STATUS_MODERATE) == BannerStatusModerate.READY
                    || changes.changed(BannerWithName.NAME)) {

                changes.modify(BannerWithName.NAME_STATUS_MODERATE, BannerNameStatusModerate.READY);
            }
        }
    }

}
