package ru.yandex.direct.core.entity.banner.type.organization;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganization;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithOrganization> {

    private final BannerWithOrganizationValidatorProvider validatorProvider;

    @Autowired
    public BannerWithOrganizationAddValidationTypeSupport(
            BannerWithOrganizationValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithOrganization>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithOrganization>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.addValidator(container))
                .getResult();
    }

    @Override
    public Class<BannerWithOrganization> getTypeClass() {
        return BannerWithOrganization.class;
    }
}
