package ru.yandex.direct.core.entity.banner.type.organization;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndVcard;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithOrganization.PERMALINK_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithOrganization.PREFER_V_CARD_OVER_PERMALINK;
import static ru.yandex.direct.core.entity.organizations.util.PermalinkUtils.newCalculatePreferVCardOverPermalink;
import static ru.yandex.direct.feature.FeatureName.IS_ENABLE_PREFER_V_CARD_OVER_PERMALINK;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAndVcardUpdateOperationTypeSupport extends
        AbstractBannerUpdateOperationTypeSupport<BannerWithOrganizationAndVcard> {

    @Autowired
    public BannerWithOrganizationAndVcardUpdateOperationTypeSupport() {
    }

    @Override
    public void beforeExecution(BannersUpdateOperationContainer updateContainer,
                                List<AppliedChanges<BannerWithOrganizationAndVcard>> appliedChanges) {
        var featureEnabled = updateContainer.isFeatureEnabledForClient(IS_ENABLE_PREFER_V_CARD_OVER_PERMALINK);
        appliedChanges.stream()
                .filter(ac -> ac.getNewValue(PERMALINK_ID) != null)
                .forEach(ac -> {
                    if (featureEnabled) {
                        ac.modify(PREFER_V_CARD_OVER_PERMALINK, newCalculatePreferVCardOverPermalink(ac.getModel()));
                    } else {
                        ac.modify(PREFER_V_CARD_OVER_PERMALINK, false);
                    }
                });
    }

    @Override
    public Class<BannerWithOrganizationAndVcard> getTypeClass() {
        return BannerWithOrganizationAndVcard.class;
    }

}
