package ru.yandex.direct.core.entity.banner.type.organization;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganization;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithOrganization> {

    private final BannerWithOrganizationValidatorProvider validatorProvider;

    @Autowired
    public BannerWithOrganizationUpdateValidationTypeSupport(
            BannerWithOrganizationValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithOrganization>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithOrganization>, Defect> vr,
            Map<Integer, AppliedChanges<BannerWithOrganization>> appliedChangesForValidModelChanges) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.updateValidator(container, appliedChangesForValidModelChanges))
                .getResult();
    }

    @Override
    public Class<BannerWithOrganization> getTypeClass() {
        return BannerWithOrganization.class;
    }
}
