package ru.yandex.direct.core.entity.banner.type.organization;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganization;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static java.util.Collections.emptySet;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationValidatorProvider {

    public ListItemValidator<BannerWithOrganization, Defect> addValidator(
            BannersAddOperationContainer container) {

        Set<Long> bannerIdsWithUnchangedOrganizations = emptySet();
        Map<Long, Organization> availableOrganizations = container.getClientOrganizations();
        boolean isCopy = container.isCopy();

        return validator(bannerIdsWithUnchangedOrganizations, availableOrganizations, isCopy);
    }

    public ListItemValidator<BannerWithOrganization, Defect> updateValidator(
            BannersUpdateOperationContainer container,
            Map<Integer, AppliedChanges<BannerWithOrganization>> appliedChanges) {

        Set<Long> bannerIdsWithUnchangedOrganizations = getBannerIdsWithUnchangedOrganizations(appliedChanges);
        Map<Long, Organization> availableOrganizations = container.getClientOrganizations();

        return validator(bannerIdsWithUnchangedOrganizations, availableOrganizations, false);
    }

    private ListItemValidator<BannerWithOrganization, Defect> validator(
            Set<Long> bannerIdsWithUnchangedOrganizations,
            Map<Long, Organization> availableOrganizations,
            boolean isCopy
    ) {
        return (index, bannerWithOrganization) -> {
            ModelItemValidationBuilder<BannerWithOrganization> ivb =
                    ModelItemValidationBuilder.of(bannerWithOrganization);

            boolean required = bannerWithOrganization instanceof CpmGeoPinBanner;
            ivb.item(BannerWithOrganization.PERMALINK_ID)
                    .checkBy(new PermalinkIdValidator(bannerWithOrganization.getId(),
                            bannerIdsWithUnchangedOrganizations,
                            availableOrganizations,
                            required,
                            isCopy));

            return ivb.getResult();
        };
    }

    private Set<Long> getBannerIdsWithUnchangedOrganizations(
            Map<Integer, AppliedChanges<BannerWithOrganization>> appliedChanges) {
        return StreamEx.of(appliedChanges.values())
                .filter(ac -> !ac.changed(BannerWithOrganization.PERMALINK_ID))
                .map(ac -> ac.getModel().getId())
                .toSet();
    }

}
