package ru.yandex.direct.core.entity.banner.type.organization;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.organizations.validation.OrganizationConstraints.checkStatus;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class PermalinkIdValidator implements Validator<Long, Defect> {

    private final Long bannerId;
    private final Set<Long> bannerIdsWithUnchangedOrganizations;
    private final Map<Long, Organization> clientOrganizations;
    private final boolean required;
    private final boolean isCopy;

    public PermalinkIdValidator(Long bannerId,
                                Set<Long> bannerIdsWithUnchangedOrganizations,
                                Map<Long, Organization> clientOrganizations,
                                boolean required,
                                boolean isCopy) {
        this.bannerId = bannerId;
        this.bannerIdsWithUnchangedOrganizations = bannerIdsWithUnchangedOrganizations;
        this.clientOrganizations = clientOrganizations;
        this.required = required;
        this.isCopy = isCopy;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long permalinkId) {
        return ItemValidationBuilder.<Long, Defect>of(permalinkId)
                .check(notNull(), When.isTrue(required))
                .check(checkStatus(clientOrganizations, isCopy),
                        When.isFalse(bannerIdsWithUnchangedOrganizations.contains(bannerId)))
                .getResult();
    }

}
