package ru.yandex.direct.core.entity.banner.type.performance;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersPerformanceMainRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE_MAIN;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

/**
 * При добавлении баннера PerformanceBannerMain
 * вставляем запись в таблицу banners_performance_main
 * Эта таблица обеспечивает уникальность баннера на группе
 */
@Component
@ParametersAreNonnullByDefault
public class BannerPerformanceMainRepositoryTypeSupport
        extends AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
        <PerformanceBannerMain, BannersPerformanceMainRecord> {
    protected BannerPerformanceMainRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNERS_PERFORMANCE_MAIN.BID, createMapper());
    }

    @Override
    protected void upsertEntity(DSLContext context, Collection<PerformanceBannerMain> banners) {
        var insertHelper = new InsertHelper<>(context, BANNERS_PERFORMANCE_MAIN);
        insertHelper.addAll(getJooqMapper(), banners);
        insertHelper.executeIfRecordsAdded();
    }

    @Override
    protected boolean isAddEntity(PerformanceBannerMain model) {
        return true;
    }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<PerformanceBannerMain> appliedChange) {
        return false;
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<PerformanceBannerMain> appliedChange) {
        return false;
    }

    private static JooqMapper<PerformanceBannerMain> createMapper() {
        return JooqMapperBuilder.<PerformanceBannerMain>builder()
                .map(property(PerformanceBannerMain.ID, BANNERS_PERFORMANCE_MAIN.BID))
                .map(property(PerformanceBannerMain.AD_GROUP_ID, BANNERS_PERFORMANCE_MAIN.PID))
                .build();
    }

    @Override
    public Class<PerformanceBannerMain> getTypeClass() {
        return PerformanceBannerMain.class;
    }
}
