package ru.yandex.direct.core.entity.banner.type.performance;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.performance.defects.PerformanceBannerMainDefects;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@Component
public class BannerPerformanceMainUpdateValidationTypeSupport extends
        AbstractBannerUpdateValidationTypeSupport<PerformanceBannerMain> {

    private final FeatureService featureService;

    @Autowired
    public BannerPerformanceMainUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<PerformanceBannerMain> getTypeClass() {
        return PerformanceBannerMain.class;
    }

    @Override
    public ValidationResult<List<PerformanceBannerMain>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<PerformanceBannerMain>, Defect> vr) {
        if (!featureService.isEnabledForClientId(container.getClientId(), FeatureName.SMART_NO_CREATIVES)) {
            return new ListValidationBuilder<>(vr)
                    .checkEach(fromPredicate(t -> false,
                            PerformanceBannerMainDefects.bannersWithoutCreativeNotEnabled()))
                    .getResult();
        }

        return vr;
    }
}
