package ru.yandex.direct.core.entity.banner.type.phone;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAndPhoneAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithOrganizationAndPhone> {

    @Override
    public Class<BannerWithOrganizationAndPhone> getTypeClass() {
        return BannerWithOrganizationAndPhone.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithOrganizationAndPhone> models) {
        // Не добавляем телефон при отсутствии организации
        models.forEach(banner -> {
            if (banner.getPermalinkId() == null) {
                banner.setPhoneId(null);
            }
        });
    }

}
