package ru.yandex.direct.core.entity.banner.type.phone;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAndPhoneAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithOrganizationAndPhone> {

    private final BannerWithOrganizationAndPhoneValidatorProvider validatorProvider;

    @Autowired
    public BannerWithOrganizationAndPhoneAddValidationTypeSupport(
            BannerWithOrganizationAndPhoneValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithOrganizationAndPhone>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithOrganizationAndPhone>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.addValidator(container, vr.getValue()))
                .getResult();
    }

    @Override
    public Class<BannerWithOrganizationAndPhone> getTypeClass() {
        return BannerWithOrganizationAndPhone.class;
    }
}
