package ru.yandex.direct.core.entity.banner.type.phone;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAndPhoneUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithOrganizationAndPhone> {

    @Override
    public Class<BannerWithOrganizationAndPhone> getTypeClass() {
        return BannerWithOrganizationAndPhone.class;
    }

    @Override
    public void beforeExecution(BannersUpdateOperationContainer updateContainer, List<AppliedChanges<BannerWithOrganizationAndPhone>> appliedChanges) {
        // Удаляем телефон при удалении организации
        appliedChanges.forEach(ac -> {
            if (ac.deleted(BannerWithOrganizationAndPhone.PERMALINK_ID)) {
                ac.modify(BannerWithOrganizationAndPhone.PHONE_ID, null);
            }
        });
    }

}
