package ru.yandex.direct.core.entity.banner.type.phone;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAndPhoneUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithOrganizationAndPhone> {

    private final BannerWithOrganizationAndPhoneValidatorProvider validatorProvider;

    @Autowired
    public BannerWithOrganizationAndPhoneUpdateValidationTypeSupport(
            BannerWithOrganizationAndPhoneValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithOrganizationAndPhone>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithOrganizationAndPhone>, Defect> vr,
            Map<Integer, AppliedChanges<BannerWithOrganizationAndPhone>> appliedChangesForValidModelChanges) {
        ListItemValidator<BannerWithOrganizationAndPhone, Defect> validator =
                validatorProvider.updateValidator(container, appliedChangesForValidModelChanges);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }

    @Override
    public Class<BannerWithOrganizationAndPhone> getTypeClass() {
        return BannerWithOrganizationAndPhone.class;
    }

}
